<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Brand;
use App\Modals\Submenu;
use App\Modals\Color;
use App\Modals\Size;
use App\Modals\Product;
use App\Modals\Main;
use App\Modals\Box;
use App\Modals\Secbox;
use App\Modals\Addbox;
use App\Modals\Contact;
use App\Modals\Order;
use App\Modals\Newspaper;
use App\Modals\Orderitem;
use Session;
use App\User;
use Carbon\Carbon;
use Hash;
use Auth;


class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {

      $totalorder = Order::count();
      $neworder = Order::where('status', 0)->count();
      $inprocessorder = Order::where('status', 1)->count();
      $deliveredorder = Order::where('status',2)->count();
      $todayorder = Order::where('created_at', '>=', Carbon::today())->count();
      $totalreceived = Order::where('status',2)->sum('amount');

      $totalpending = Order::where('status','!=',2)->sum('amount');
      $products = Product::all();
      $gtotal = $totalorder+$totalreceived;
        return view('admin.dashboard',['totalorder'=>$totalorder,'neworder'=>$neworder,'inprocessorder'=>$inprocessorder,
        'deliveredorder'=>$deliveredorder,'todayorder'=>$todayorder,
        'totalreceived'=>$totalreceived,'totalpending'=>$totalpending,'products'=>$products,'gtotal'=>$gtotal]);
    }


    public function brands()
    {
        $brands = Brand::all();
        return view('admin.brands', ['brands'=>$brands]);
    }

    public function menus()
    {
        $menus = Menu::all();
        return view('admin.menus', ['menus'=>$menus]);
    }

    public function getnews()
    {
        $news = Newspaper::all();
        return view('admin.news', ['news'=>$news]);
    }

    public function submenus()
    {
        $submenus = Submenu::all();
        $menus = Menu::all();

        return view('admin.submenus', ['submenus'=>$submenus,'menus'=>$menus]);
    }

    public function products()
    {
        $products = Product::all();
        $submenus = Menu::all();
          $brands = Brand::all();
        return view('admin.products', ['submenus'=>$submenus,'products'=>$products,'brands'=>$brands]);
    }

    public function getmains()
    {
        $main = Main::first();

        return view('admin.mains', ['main'=>$main]);
    }


    public function editmains(Request $request)
    {
        $main = Main::first();
        $main->h1 = $request->h1;
        $main->h2 = $request->h2;
        $main->h3 = $request->h3;

        if($request->pic)
        {
        $value = $request->pic;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $main->pic =  $namefile;
        }

        $main->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function submitnews(Request $request)
    {
        $main = new Newspaper();
        $main->name = $request->description;

        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $main->image =  $namefile;
        }

        $main->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function deletenews($id)
    {
        $main = Newspaper::where('id', $id)->first();
        $main->delete();
        Session::flash('success', 'Successfully, deleted !');
        return redirect()->back();
    }



    public function getboxes()
    {
        $box = Box::first();

        return view('admin.boxes', ['box'=>$box]);
    }


    public function contacts()
    {
        $contacts = Contact::all();

        return view('admin.contacts', ['contacts'=>$contacts]);
    }


    public function discardcontacts($id)
    {
        $contacts = Contact::where('id', $id)->first();
        $contacts->status = 1;
        $contacts->save();
        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function editboxes(Request $request)
    {
        $box = Box::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;
        $box->ch1 = $request->ch1;
        $box->ch2 = $request->ch2;

        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image3 =  $namefile;
        }

        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function getsecboxes()
    {
        $box = Secbox::first();

        return view('admin.secboxes', ['box'=>$box]);
    }


    public function editsecboxes(Request $request)
    {
        $box = Secbox::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }


        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function getaddboxes()
    {
        $box = Addbox::first();

        return view('admin.addboxes', ['box'=>$box]);
    }


    public function editaddboxes(Request $request)
    {
        $box = addbox::first();
        $box->h1 = $request->h1;
        $box->h2 = $request->h2;
        $box->h3 = $request->h3;
        $box->h4 = $request->h4;


        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image =  $namefile;
        }



        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addbrands(Request $request)
    {
        $brands = new Brand();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function editbrands(Request $request)
    {
        $brands = Brand::where('id',$request->brand_id)->first();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }


    public function editmenus(Request $request)
    {
        $brands = Menu::where('id',$request->menu_id)->first();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }

    public function editsubmenus(Request $request)
    {
        $brands = Submenu::where('id',$request->submenu_id)->first();
        $brands->name = $request->name;
          $brands->menu_id = $request->menu_id;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }


    public function showproducts($id)
    {
        $product = Product::where('id',$id)->first();
        $submenus = Menu::all();
          $brands = Brand::all();

        return view('admin.showproducts', ['submenus'=>$submenus,'product'=>$product,'brands'=>$brands]);
    }
    public function addmenus(Request $request)
    {
        $menus = new Menu();
        $menus->name = $request->name;
        $menus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addsubmenus(Request $request)
    {
        $submenus = new Submenu();
        $submenus->name = $request->name;
        $submenus->menu_id = $request->menu_id;
        $submenus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function addproducts(Request $request)
    {


        $product = new Product();
        $product->name = $request->name;
        $product->details = $request->details;
        $product->description = $request->description;
        $product->brand_id = $request->brand_id;
        $product->menu_id = $request->menu_id;
        $product->submenu_id = 0;
        $product->price = $request->price;
        $product->actual_price = $request->actual_price;
        $product->sale = $request->sale;
        $product->stock = $request->stock;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image3 =  $namefile;
        }

        if($request->image4)
        {
        $value = $request->image4;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image4 =  $namefile;
        }

        $product->save();

        // $myArray = explode(',', $request->colors);
        // foreach($myArray as $ma)
        // {
        // $color = new Color();
        // $color->product_id = $product->id;
        // $color->name = $ma;
        // $color->save();
        // }
        //
        // $myArray1 = explode(',', $request->sizes);
        // foreach($myArray1 as $ma1)
        // {
        // $size = new Size();
        // $size->product_id = $product->id;
        // $size->name = $ma1;
        // $size->save();
        // }


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function editproducts(Request $request)
    {


        $product = Product::where('id',$request->product_id)->first();
        $product->name = $request->name;
        $product->details = $request->details;
        $product->description = $request->description;
        $product->brand_id = $request->brand_id;
        $product->menu_id = $request->menu_id;
        $product->submenu_id = 0;
        $product->price = $request->price;
        $product->actual_price = $request->actual_price;
        $product->sale = $request->sale;
        $product->stock = $request->stock;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image3 =  $namefile;
        }

        if($request->image4)
        {
        $value = $request->image4;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image4 =  $namefile;
        }

        $product->save();

        // $myArray = explode(',', $request->colors);
        // foreach($myArray as $ma)
        // {
        // $color = new Color();
        // $color->product_id = $product->id;
        // $color->name = $ma;
        // $color->save();
        // }
        //
        // $myArray1 = explode(',', $request->sizes);
        // foreach($myArray1 as $ma1)
        // {
        // $size = new Size();
        // $size->product_id = $product->id;
        // $size->name = $ma1;
        // $size->save();
        // }


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function neworders()
    {
      $orders =  Order::where('status' , 0)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }

    public function inprocessorders()
    {
      $orders =  Order::where('status' , 1)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }

    public function deliveredorders()
    {
      $orders =  Order::where('status' , 2)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }


    public function orderdetails($id)
    {
      $order =  Order::where('id' , $id)->first();

      return view('admin.showorder' , ['order'=>$order]);
    }

    public function changestatus($id,$val)
    {
      $order =  Order::where('id' , $id)->first();

      $order->status = $val;
      $order->save();

      Session::flash('success', 'Successfully, changed !');
      return redirect()->back();
    }


    public function deleteproducts($id)
    {
      $order =  Product::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function deletemenu($id)
    {
      $order =  Menu::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }

    public function deletesubmenu($id)
    {
      $order =  Submenu::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function deletebrand($id)
    {
      $order =  Brand::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function changepass(Request $request)
    {
      $user =  User::first();
      $user->password = Hash::make($request->name);

      $user->save();

      Session::flash('success', 'Successfully, changed !');
      return redirect()->back();
    }
}
