@extends('layouts.admin')



@section('styles')

@endsection



@section('content')

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->


<div class="content-page">

    <!-- Start content -->

    <div class="content">

        <div class="container-fluid">

          <div class="row">

              <div class="col-sm-12">

                  <div class="page-title-box">

                      <div class="row align-items-center">

                          <div class="col-md-8">

                              <h4 class="page-title mb-0">Contacts</h4>

                              <ol class="breadcrumb m-0">

                                  <li class="breadcrumb-item"><a href="#">Dashboard</a></li>

                                  <li class="breadcrumb-item active" aria-current="page">Contacts</li>

                              </ol>

                          </div>



                      </div>



                  </div>

              </div>

          </div>

          <!-- end row -->

            <div class="row">

                <div class="col-lg-12">

                    <div class="card">

                        <div class="card-body">

                            <h4 class="mt-0 header-title">Contacts</h4>

                            <div class="table-responsive mt-4">

                                <table class="table  table-striped table-hover mb-0">

                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Contact</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Message</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Created At</th>
                                            <th scope="col" >Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                      @foreach($contacts as $contact)
										  <tr>
										  <td>{{$loop->iteration}}</td>
											<td>{{$contact->name}}</td>
                      <td>{{$contact->contact}}</td>
                      <td>{{$contact->email}}</td>
                      <td>{{$contact->message}}</td>
                      <td>@if($contact->status == 1) Discarded @else Pending @endif</td>
                      <td>{{$contact->created_at}}</td>
											<td>
                        @if($contact->status == 0)
                      <a href="{{ route('admin.discardcontacts' , $contact->id)}}"  class="btn btn-warning btn-sm" >Discard</a>
                      @else N/A @endif
                      </td>
										</tr>
                    @endforeach







                                    </tbody>

                                </table>



                            </div>


                        </div>

                    </div>

                </div>

            </div>

            <!-- end row -->


        </div> <!-- container-fluid -->



    </div> <!-- content -->



    <footer class="footer">

        © 2020 - 2021  Mommy Kloset

    </footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->

<div class="modal fade" id="menumodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Menu</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form method="post" action="{{ route('admin.addmenus')}}">
      <div class="modal-body">

          <div class="row">
            <div class="col-md-12">
              <label>Name</label>
              <input type="text" name="name" required class="form-control"/>
            </div>
          </div>


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save changes</button>
      </div>
      {{ csrf_field()}}
      </form>
    </div>
  </div>
</div>

@endsection



@section('scripts')


@endsection
