@extends('layouts.admin')



@section('styles')

@endsection



@section('content')

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->


<div class="content-page">

    <!-- Start content -->

    <div class="content">

        <div class="container-fluid">

          <div class="row">

              <div class="col-sm-12">

                  <div class="page-title-box">

                      <div class="row align-items-center">

                          <div class="col-md-8">

                              <h4 class="page-title mb-0">Order</h4>

                              <ol class="breadcrumb m-0">

                                  <li class="breadcrumb-item"><a href="#">Dashboard</a></li>

                                  <li class="breadcrumb-item active" aria-current="page">Order</li>

                              </ol>

                          </div>

                          <div class="col-md-4">

                              <div class="float-right d-none d-md-block">

                                  <div class="dropdown">





                                  </div>

                              </div>

                          </div>

                      </div>



                  </div>

              </div>

          </div>

          <!-- end row -->

            <div class="row">

                <div class="col-lg-12">

                    <div class="card">

                        <div class="card-body">

                          <div class="row">
                            <div class="col-md-12">
                              @if($order->status == 0)
                              <a href="{{ route('admin.changestatus' , [$order->id , '1'])}}" class="btn btn-success pull-right"> Mark as Inprocess</a>
                              @endif

                              @if($order->status == 1)
                              <a href="{{ route('admin.changestatus' , [$order->id , '2'])}}" class="btn btn-success pull-right"> Mark as Delivered</a>
                              @endif
                            </div>
                            <div class="col-md-12">
                              <h5>Person Details</h5>

                            <table class="table">
                              <tr>
                                <th>Name</th>
                                <td>{{$order->name}}</td>
                                <th>Contact</th>
                                <td>{{$order->contact}}</td>
                              </tr>

                              <tr>
                                <th>Email</th>
                                <td>{{$order->email}}</td>
                                <th>Address</th>
                                <td>{{$order->address}}</td>
                              </tr>

                              <tr>
                                <th>Order #</th>
                                <td>{{$order->order_no}}</td>
                                <th>Total Amount</th>
                                <td>{{$order->amount}}</td>
                              </tr>

                              <tr>
                                <th>Payment Type</th>
                                <td>{{$order->payment}}</td>
                                <th>Notes</th>
                                <td>{{$order->notes}}</td>
                              </tr>

                              <tr>
                                <th>Status</th>
                                <td>@if($order->status == 0 ) Pending/New
                                @elseif($order->status == 1) Inprocess
                              @else Delivered @endif</td>
                              <th>Order Date</th>
                              <td>{{$order->created_at}}</td>
                              </tr>

                            </table>
                            </div>



                          </div>

                          <hr style="width:100%">

                          <div class="row">

                            <div class="col-md-12">
                              <h5>Item Details</h5>
                              <table class="table">
                                <thead>
                                  <tr>
                                  <th>Product</th>
                                  <th>Vendor</th>
                                  <th>Menu </th>
                                  <th>Quantity</th>
                                  <th>Price</th>
                                  </tr>
                                </thead>

                                <tbody>
                                  @foreach($order->orderitems as $items)
                                  <tr>
                                    <td>{{$items->product->name}}</td>
                                    <td>@if($items->product->brand){{$items->product->brand->name}}@endif</td>
                                    <td> {{$items->product->menu->name}} </td>
                                    <td>{{$items->qty}}</td>
                                    <td>{{$items->amount}}</td>
                                  </tr>
                                  @endforeach
                                </tbody>
                              </table>
                            </div>


                          </div>

                        </div>

                    </div>

                </div>

            </div>

            <!-- end row -->


        </div> <!-- container-fluid -->



    </div> <!-- content -->



    <footer class="footer">

        © 2020 - 2021  Mommy Kloset

    </footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->

@endsection



@section('scripts')


@endsection
