@extends('layouts.main')

@section('styles')
@endsection

@section('content')
@include('includes.smallHeader')
<!-- Breadcrumbs -->
<div class="breadcrumbs">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="bread-inner">
          <ul class="bread-list">
            <li><a href="index1.html">Home<i class="ti-arrow-right"></i></a></li>
            <li class="active"><a href="#">Cart</a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Breadcrumbs -->

<!-- Shopping Cart -->
<div class="shopping-cart section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <!-- Shopping Summery -->
        <table class="table shopping-summery">
          <thead>
            <tr class="main-hading">
              <th>PRODUCT</th>
              <th>NAME</th>
              <th class="text-center">UNIT PRICE</th>
              <th class="text-center">QUANTITY</th>
              <th class="text-center">TOTAL</th>
              <th class="text-center"><a href="{{ route('removeall')}}"><i class="ti-trash remove-icon"></i></a></th>
            </tr>
          </thead>
          <tbody>
            <?php $total = 0; $check= 0; ?>
            @if(session('cart'))
            @foreach(session('cart') as $id => $details)
                <?php $total += ($details['price'] * $details['quantity']); $check++;?>
            <tr>
              <td class="image" data-title="No"><img src="{{ asset('storage/products/'.$details['photo'])}}" alt="#"></td>
              <td class="product-des" data-title="Description">
                <p class="product-name"><a href="#">{{$details['name']}}</a></p>

              </td>
              <td class="price" data-title="Price"><span> @if($details['actual_price'] != $details['price']) <s> {{$details['actual_price']}} PKR</s>  @endif {{ $details['price'] }} PKR </span></td>
              <td class="qty" data-title="Qty"><!-- Input Order -->
                <div class="input-group">
                  <div class="button minus">
                    <a href="{{ route('substractquantity', $details['id'])}}" class="btn btn-xs btn-success">-</a>
                  </div>
                  <input type="text" disabled name="quant[1]" class="input-number" value="{{ $details['quantity'] }}"  data-min="1" data-max="100" >
                  <div class="button plus">
                    <a href="{{ route('addtocart', $details['id'])}}" class="btn btn-xs btn-success">+</a>
                  </div>
                </div>
                <!--/ End Input Order -->
              </td>
              <td class="total-amount" data-title="Total"><span><?php $sum = $details['price'] * $details['quantity']; ?> {{$sum}} PKR</span></td>
              <td class="action" data-title="Remove"><a href="{{ route('removeitem', $details['id'])}}"><i class="ti-trash remove-icon"></i></a></td>
            </tr>

            @endforeach
            @endif
          </tbody>
        </table>
        <!--/ End Shopping Summery -->
      </div>
    </div>
    <div class="row">
      <div class="col-12">
        <!-- Total Amount -->
        <div class="total-amount">
          <div class="row">
            <div class="col-lg-8 col-md-5 col-12">

            </div>
            <div class="col-lg-4 col-md-7 col-12">
              <div class="right">
                <ul>
                  <li>Cart Subtotal<span>{{ $total }} PKR</span></li>
                   
                  <?php $asd = $total + 0; ?>
                  <li class="last">You Pay<span>{{ $asd }} PKR</span></li>
                </ul>
                <div class="button5">
                @if($check != 0)  <a href="{{ route('checkout')}}" class="btn">Checkout</a> @endif
                  <a href="{{ route('main')}}" class="btn">Continue shopping</a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--/ End Total Amount -->
      </div>
    </div>
  </div>
</div>
<!--/ End Shopping Cart -->



@endsection

@section('scripts')

@endsection
