@extends('layouts.main')

@section('styles')
<style>
.invoice-title h2, .invoice-title h3 {
    display: inline-block;
}

.table > tbody > tr > .no-line {
    border-top: none;
}

.table > thead > tr > .no-line {
    border-bottom: none;
}

.table > tbody > tr > .thick-line {
    border-top: 2px solid;
}

</style>
@endsection

@section('content')
@include('includes.smallHeader')
<!-- Start main-content -->
<div class="main-content">
  <!-- Section: inner-header -->
  <section class="inner-header divider parallax layer-overlay overlay-dark-5" data-bg-img="{{ asset('assets/main/images/bg/bg6.jpg')}}" style="background-image: url(&quot;{{ asset('assets/main/images/bg/bg6.jpg')}}&quot;); background-position: 50% 58px;">
    <div class="container pt-30 pb-40">
      <!-- Section Content -->
      <div class="section-content">
        <div class="row">
          <div class="col-md-12">
            <h2 class="title text-white text-center">Thanks</h2>

          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Section: About -->
 <section style="margin-top:50px;">
    <div class="container">
      <div class="row pt-10">
        <div class="col-md-12" style="background: #3a641a;
    padding: 50px;margin-bottom: 50px;">
          <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
              <div class="icon-box left media bg-black-333 p-30 mb-20"> <a class="media-left pull-left" href="#"> <i class="pe-7s-map-2 text-theme-color-2"></i></a>
                <div class="media-body text-white"><h3> <strong><u>Thank you for placing Order</u></h3></strong>
                  <p class="text-white">Your order is place and will be delivered in 7 working days.incase of any query or details please contact us freely</p>
                </div>
              </div>
              <hr>
            </div>

            <div class="col-md-12" style="color:white">
              <div class="row">
         <div class="col-md-12">
     		<div class="invoice-title">
     			<h2>Invoice</h2><h3 class="pull-right">Order # {{$order->order_no}}</h3>
     		</div>
     		<hr>
     		<div class="row">
     			<div class="col-md-6">
     				<address>
     				<strong>Billed To:</strong><br>
     					{{$order->name}}<br>
     					{{$order->contact}}<br>
     					{{$order->email}}
     				</address>
     			</div>
     			<div class="col-md-6 text-right">
     				<address>
         			<strong>Shipped To:</strong><br>
     					{{$order->address}}
     				</address>
     			</div>
     		</div>
     		<div class="row">
     			<div class="col-md-6">
     				<address>
     					<strong>Payment Method:</strong><br>
     					{{$order->payment}}
     				</address>
     			</div>
     			<div class="col-md-6 text-right">
     				<address>
     					<strong>Order Date:</strong><br>
     				{{$order->created_at}}<br><br>
     				</address>
     			</div>
     		</div>
     	</div>
     </div>


     <div class="row">
      	<div class="col-md-12">
      		<div class="panel panel-default">
      			<div class="panel-heading">
      				<h3 class="panel-title"><strong>Order summary</strong></h3>
      			</div>
      			<div class="panel-body">
      				<div class="table-responsive">
      					<table class="table table-condensed">
      						<thead>
                                  <tr>
          							<td><strong>Item</strong></td>
          							<td class="text-center"><strong>Price</strong></td>
          							<td class="text-center"><strong>Quantity</strong></td>
          							<td class="text-right"><strong>Totals</strong></td>
                                  </tr>
      						</thead>
      						<tbody>
      							<!-- foreach ($order->lineItems as $line) or some such thing here -->
                    @foreach($order->orderitems as $o)
      							<tr>
      								<td>{{$o->product->name}}</td>
      								<td class="text-center">{{$o->product->price}}</td>
      								<td class="text-center">{{$o->qty}}</td>
      								<td class="text-right">{{$o->amount}}</td>
      							</tr>
                    @endforeach



    						
    							<tr>
    								<td class="no-line"></td>
    								<td class="no-line"></td>
    								<td class="no-line text-center"><strong>Total</strong></td>
    								<td class="no-line text-right">{{$order->amount}} PKR</td>
    							</tr>
      						</tbody>
      					</table>
      				</div>
      			</div>
      		</div>
      	</div>
      </div>






            </div>

          </div>
        </div>

      </div>
    </div>
  </section>

</div>
<!-- end main-content -->

@endsection

@section('scripts')
<!-- Contact Form Validation-->
<script type="text/javascript">
  $("#contact_form").validate({
    submitHandler: function(form) {
      var form_btn = $(form).find('button[type="submit"]');
      var form_result_div = '#form-result';
      $(form_result_div).remove();
      form_btn.before('<div id="form-result" class="alert alert-success" role="alert" style="display: none;"></div>');
      var form_btn_old_msg = form_btn.html();
      form_btn.html(form_btn.prop('disabled', true).data("loading-text"));
      $(form).ajaxSubmit({
        dataType:  'json',
        success: function(data) {
          if( data.status == 'true' ) {
            $(form).find('.form-control').val('');
          }
          form_btn.prop('disabled', false).html(form_btn_old_msg);
          $(form_result_div).html(data.message).fadeIn('slow');
          setTimeout(function(){ $(form_result_div).fadeOut('slow') }, 6000);
        }
      });
    }
  });
</script>
@endsection
