<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'Web\WebController@index')->name('main');
Route::get('/items-list/{type}/{id}', 'Web\WebController@itemLists')->name('itemLists');
Route::get('/item-list', 'Web\WebController@itemList')->name('itemList');
Route::get('/item-detail/{id}', 'Web\WebController@itemDetail')->name('itemDetail');
Route::get('/cart', 'Web\WebController@cart')->name('cart');
Route::get('/addtocart/{id}', 'Web\WebController@addtocart')->name('addtocart');
Route::get('/removeitem/{id}', 'Web\WebController@removeitem')->name('removeitem');
Route::get('/removeall', 'Web\WebController@removeall')->name('removeall');
Route::get('/substractquantity/{id}', 'Web\WebController@substractquantity')->name('substractquantity');
Route::get('/checkout', 'Web\WebController@checkout')->name('checkout');
Route::post('/submitcheckout', 'Web\WebController@submitcheckout')->name('submitcheckout');
Route::get('/contact', 'Web\WebController@contact')->name('contact');
Route::get('/reg', 'Web\WebController@reg')->name('reg');
Route::get('/about', 'Web\WebController@about')->name('about');
Route::get('/news', 'Web\WebController@news')->name('news');
Route::get('/thanks/{id}', 'Web\WebController@thanks')->name('thanks');
Route::post('/submitcontact', 'Web\WebController@submitcontact')->name('submitcontact');
Route::post('/submitreg', 'Web\WebController@submitreg')->name('submitreg');
Route::post('/booknow', 'Web\WebController@booknow')->name('booknow');

Auth::routes();
// to verify the role of the users
Route::get('/home', 'HomeController@loginCheck')->name('home');
Route::get('/user/logout', 'HomeController@userLogout')->name('user.logout');
// admin controllers
Route::middleware('auth')->prefix('admin')->group(function() {
          Route::get('/dashboard', 'Admin\AdminController@dashboard')->name('admin.dashboard');

          Route::post('/changepass', 'Admin\AdminController@changepass')->name('admin.changepass');

          Route::get('/brands', 'Admin\AdminController@brands')->name('admin.brands');
          Route::post('/addbrands', 'Admin\AdminController@addbrands')->name('admin.addbrands');
          Route::post('/editbrands', 'Admin\AdminController@editbrands')->name('admin.editbrands');

          Route::get('/menus', 'Admin\AdminController@menus')->name('admin.menus');
          Route::post('/addmenus', 'Admin\AdminController@addmenus')->name('admin.addmenus');
          Route::post('/editmenus', 'Admin\AdminController@editmenus')->name('admin.editmenus');

          Route::get('/submenus', 'Admin\AdminController@submenus')->name('admin.submenus');
          Route::post('/addsubmenus', 'Admin\AdminController@addsubmenus')->name('admin.addsubmenus');
          Route::post('/editsubmenus', 'Admin\AdminController@editsubmenus')->name('admin.editsubmenus');

          Route::get('/products', 'Admin\AdminController@products')->name('admin.products');
          Route::post('/addproducts', 'Admin\AdminController@addproducts')->name('admin.addproducts');
          Route::get('/showproducts/{id}', 'Admin\AdminController@showproducts')->name('admin.showproducts');
          Route::post('/editproducts', 'Admin\AdminController@editproducts')->name('admin.editproducts');
          Route::get('/deleteproducts/{id}', 'Admin\AdminController@deleteproducts')->name('admin.deleteproducts');
          Route::get('/deletemenu/{id}', 'Admin\AdminController@deletemenu')->name('admin.deletemenu');
          Route::get('/deletesubmenu/{id}', 'Admin\AdminController@deletesubmenu')->name('admin.deletesubmenu');
          Route::get('/deletebrand/{id}', 'Admin\AdminController@deletebrand')->name('admin.deletebrand');

          Route::get('/getmains', 'Admin\AdminController@getmains')->name('admin.getmains');
          Route::post('/editmains', 'Admin\AdminController@editmains')->name('admin.editmains');

          Route::get('/getnews', 'Admin\AdminController@getnews')->name('admin.getnews');
          Route::post('/submitnews', 'Admin\AdminController@submitnews')->name('admin.submitnews');
          Route::get('/deletenews/{id}', 'Admin\AdminController@deletenews')->name('admin.deletenews');

          Route::get('/getboxes', 'Admin\AdminController@getboxes')->name('admin.getboxes');
          Route::post('/editboxes', 'Admin\AdminController@editboxes')->name('admin.editboxes');


          Route::get('/getsecboxes', 'Admin\AdminController@getsecboxes')->name('admin.getsecboxes');
          Route::post('/editsecboxes', 'Admin\AdminController@editsecboxes')->name('admin.editsecboxes');

          Route::get('/getaddboxes', 'Admin\AdminController@getaddboxes')->name('admin.getaddboxes');
          Route::post('/editaddboxes', 'Admin\AdminController@editaddboxes')->name('admin.editaddboxes');

          Route::get('/contacts', 'Admin\AdminController@contacts')->name('admin.contacts');
          Route::get('/discardcontacts/{id}', 'Admin\AdminController@discardcontacts')->name('admin.discardcontacts');


          Route::get('/neworders', 'Admin\AdminController@neworders')->name('admin.neworders');
          Route::get('/inprocessorders', 'Admin\AdminController@inprocessorders')->name('admin.inprocessorders');
          Route::get('/deliveredorders', 'Admin\AdminController@deliveredorders')->name('admin.deliveredorders');
          Route::get('/orderdetails/{id}', 'Admin\AdminController@orderdetails')->name('admin.orderdetails');
          Route::get('/changestatus/{id}/{val}', 'Admin\AdminController@changestatus')->name('admin.changestatus');
});
