@extends('layouts.app')



@section('styles')

@endsection



@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
  <!-- Content -->

  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
    <div class="col-md-12">
         <button
        type="button"
        class="btn btn-primary"
        data-bs-toggle="modal"
        data-bs-target="#basicModal"
        style="float:right"
      >
        Add New Product
      </button>
    </div>
      <div class="col-lg-12 col-md-12 order-1">
        <div class="row">

          <div class="col-md-12">
            <div class="card">
              <h5 class="card-header">Products</h5>
              <div class="table-responsive text-nowrap">
                <table class="table">
                  <thead class="table-dark">
                    <tr>
                      <th>Name</th>
                      <th>Icon</th>
                      <th>Price</th>
                      <th>Qty</th>
                      <th>Description</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody class="table-border-bottom-0">
                    @foreach($products as $pro)
                    <tr>
                      <td><i class="fab fa-angular fa-lg text-danger me-3"></i> <strong>{{$pro->name}}</strong></td>

                      <td>
                        <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                          <li
                            data-bs-toggle="tooltip"
                            data-popup="tooltip-custom"
                            data-bs-placement="top"
                            class="avatar avatar-xs pull-up"
                            title="Lilian Fuller"
                          >
                            <img src="{{ $pro->image}}" alt="Avatar" class="rounded-circle" />
                          </li>

                        </ul>
                      </td>


                      <td>{{$pro->price}}KD</td>
                      <td>{{$pro->qty}}</td>
                      <td>{{$pro->description}}</td>

                      <td>
                        <div class="dropdown">
                          <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                            <i class="bx bx-dots-vertical-rounded"></i>
                          </button>
                          <div class="dropdown-menu">
                            <a class="dropdown-item" href="javascript:void(0);"
                              ><i class="bx bx-edit-alt me-1"></i> Edit</a
                            >
                            <a class="dropdown-item" href="javascript:void(0);"
                              ><i class="bx bx-trash me-1"></i> Delete</a
                            >
                          </div>
                        </div>
                      </td>
                    </tr>
                    @endforeach
                    


                  </tbody>
                </table>
              </div>
            </div>
          </div>
      <!-- Total Revenue -->

      <!--/ Total Revenue -->

      </div>
    </div>




  </div>

</div>
  <!-- Footer -->
  <footer class="content-footer footer bg-footer-theme">
    <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
      <div class="mb-2 mb-md-0">
        ©
        <script>
          document.write(new Date().getFullYear());
        </script>
        , made with ❤️
      </div>

    </div>
  </footer>
  <!-- / Footer -->

  <div class="content-backdrop fade"></div>

</div>









<div class="modal fade" id="basicModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel1">Add New Product</h5>
        <button
          type="button"
          class="btn-close"
          data-bs-dismiss="modal"
          aria-label="Close"
        ></button>
      </div>
      <form method="post" action="{{ route('addproduct')}}" enctype="multipart/form-data">
      <div class="modal-body">
           <div class="row">
          <div class="col mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="name" name="name" required class="form-control" />
          </div>
        </div>
        
        
         <div class="row">
          <div class="col mb-3">
            <label for="price" class="form-label">Price</label>
            <input type="number" name="price" required class="form-control" />
          </div>
        </div>
        
        
        
         <div class="row">
          <div class="col mb-3">
            <label for="nameBasic" class="form-label">Quantity</label>
            <input type="number" name="qty" required class="form-control" />
          </div>
        </div>
        
        
        
         <div class="row">
          <div class="col mb-3">
            <label for="description" class="form-label">Description</label>
            <input type="text" name="description" required class="form-control" />
          </div>
        </div>
          
          
          
        <div class="row">
          <div class="col mb-3">
            <label for="nameBasic" class="form-label">Image</label>
            <input type="file" name="file" required class="form-control" />
          </div>
        </div>
        {{ csrf_field()}}
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
          Close
        </button>
        <button type="submit" class="btn btn-primary">Save changes</button>
      </div>
    </form>
    </div>
  </div>
</div>





@endsection



@section('scripts')
@endsection
