<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Grade;
use App\Modals\Student;
use App\Modals\Teacher;
use App\Modals\Setting;
use App\Modals\Course;
use App\Modals\Registration;
use App\Modals\Expectation;
use App\Modals\Consideration;
use App\Modals\Contact;
use App\Modals\Outline;
use DB;
use Session;
use Hash;
use Auth;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {
        $studentcount = Student::count();
        $teachercount = Teacher::count();
        $pendingpayment = Registration::where('status' , 0)->count();
        $gradereg = DB::table('registrations')
                 ->select('grade_id', DB::raw('count(*) as total'))
                 ->groupBy('grade_id')
                 ->get();
        $students = Registration::where('status' , 0)->get();
                 // dd($coursereg);
        return view('admin.dashboard', ['students'=>$students,'studentcount'=>$studentcount,'teachercount'=>$teachercount,'pendingpayment'=>$pendingpayment,'gradereg'=>$gradereg]);
    }
    public function grades()
    {
      $grades = Grade::all();
      return view('admin.grades', ['grades'=>$grades]);
    }
    public function addGrade(Request $request)
    {
      $validatedData = $request->validate([
        'name' => 'required|max:255',
      ]);

      try {

      $grade = new Grade();
      $grade->name = $request->name;
      $grade->description = $request->description;
      $grade->save();

      Session::flash('success', 'Successfully, Grade Added !');
      return redirect()->back();

    } catch (\Exception $e) {

    }

      Session::flash('error', 'Something went wrong!');
      return redirect()->back();
    }
    public function deleteGrade(Request $request)
    {
      $validatedData = $request->validate([
        'grade_id' => 'required',
      ]);

      try {

      $grade = Grade::where('id',$request->grade_id)->first();
      $grade->delete();

      Session::flash('success', 'Successfully, Grade Deleted !');
      return redirect()->back();

    } catch (\Exception $e) {

    }

      Session::flash('error', 'Something went wrong!');
      return redirect()->back();
    }
    public function courses()
    {
        $grades = Grade::all();
        $courses = Course::all();
        return view('admin.courses',['grades'=>$grades,'courses'=>$courses]);
    }



    public function addCourse(Request $request)
    {
      $validatedData = $request->validate([
        'name' => 'required|max:255',
        'grade' => 'required',
      ]);

      // dd($request->input());
      try {

      $course = new Course();
      $course->name = $request->name;
      $course->description = $request->description;
      $course->price = $request->price;
      $course->prerequisite = $request->prerequisite;
      $course->department = $request->department;
      $course->course_developer = $request->course_developer;
      $course->development_date = $request->development_date;
      $course->revision_date = $request->revision_date;
      $course->course_reviser = $request->course_reviser;
      $course->course_type = $request->course_type;
      $course->ministry_course_code = $request->ministry_course_code;
      $course->credit_value = $request->credit_value;
      $course->satrategy = $request->satrategy;
      $course->evaluation = $request->evaluation;
      $course->ministry_curriculum_policy_doc = $request->ministry_curriculum_policy_document;

      $course->grade_id = $request->grade;
      $course->save();

      if($request->overall)
      {
      foreach($request->overall as $index=>$o)
      {

      $expectation = new Expectation();
      $expectation->title = $o;
      $expectation->description = $request->overdetail[$index];
      $expectation->course_id=$course->id;
      $expectation->save();

      }
    }

    if($request->contitle)
    {
    foreach($request->contitle as $index=>$c)
    {

    $consideration = new Consideration();
    $consideration->title = $c;
    $consideration->description = $request->condetail[$index];
    $consideration->course_id=$course->id;
    $consideration->save();

    }
  }

    if($request->unittitle)
    {
    foreach($request->unittitle as $index=>$t)
    {

    $outline = new Outline();
    $outline->title = $t;
    $outline->timeline = $request->unithour[$index];
    $outline->course_id=$course->id;
    $outline->save();

    }
  }

      Session::flash('success', 'Successfully, Course Added !');
      return redirect()->back();

    } catch (\Exception $e) {

    }

      Session::flash('error', 'Something went wrong!');
      return redirect()->back();
    }


    public function deleteCourse(Request $request)
    {
      $validatedData = $request->validate([
        'course_id' => 'required',
      ]);

      try {

      $course = Course::where('id',$request->course_id)->first();
      $course->delete();

      Session::flash('success', 'Successfully, Course Deleted !');
      return redirect()->back();

    } catch (\Exception $e) {

    }

      Session::flash('error', 'Something went wrong!');
      return redirect()->back();
    }

	public function contactquery()
    {
      $contacts = Contact::all();
        return view('admin.contactquery', ['contacts'=>$contacts]);
    }
    public function delete_contactus($id)
      {
        $contacts = Contact::where('id', $id)->first();
        $contacts->delete();
        Session::flash('success', 'Successfully, Deleted !');
        return redirect()->back();
      }
	public function studentdetail($id)
    {
        $student = Student::where('id', $id)->first();
        return view('admin.studentdetail' , ['student'=>$student]);
    }

    public function newCourse()
      {
        $grades = Grade::all();
        $courses = Course::all();
        return view('admin.addcourse',['grades'=>$grades,'courses'=>$courses]);

      }

      public function editviewCourse($id)
        {
          $grades = Grade::all();
          $courses = Course::all();

          $c = Course::where('id',$id)->first();
          return view('admin.editcourse',['grades'=>$grades,'courses'=>$courses,'c'=>$c]);

        }


        public function editCourse(Request $request)
        {
          $validatedData = $request->validate([
            'name' => 'required|max:255',
            'grade' => 'required',
          ]);

          try {

          $course = Course::where('id', $request->course_id)->first();
          $course->name = $request->name;
          $course->description = $request->description;
          $course->price = $request->price;
          $course->prerequisite = $request->prerequisite;
          $course->department = $request->department;
          $course->course_developer = $request->course_developer;
          $course->development_date = $request->development_date;
          $course->revision_date = $request->revision_date;
          $course->course_reviser = $request->course_reviser;
          $course->course_type = $request->course_type;
          $course->ministry_course_code = $request->ministry_course_code;
          $course->credit_value = $request->credit_value;
          $course->satrategy = $request->satrategy;
          $course->evaluation = $request->evaluation;
          $course->ministry_curriculum_policy_doc = $request->ministry_curriculum_policy_document;

          $course->grade_id = $request->grade;
          $course->update();

          if($request->overall)
          {
          foreach($request->overall as $index=>$o)
          {

          $expectation = Expectation::where('id', $request->overallid[$index])->first();
          $expectation->title = $o;
          $expectation->description = $request->overdetail[$index];
          $expectation->course_id=$course->id;
          $expectation->save();

          }
        }

        if($request->contitle)
        {
        foreach($request->contitle as $index=>$c)
        {

        $consideration = Consideration::where('id', $request->conid[$index])->first();
        $consideration->title = $c;
        $consideration->description = $request->condetail[$index];
        $consideration->course_id=$course->id;
        $consideration->save();

        }
      }

        if($request->unittitle)
        {
        foreach($request->unittitle as $index=>$t)
        {

        $outline = Outline::where('id', $request->uniid[$index])->first();

        $outline->title = $t;
        $outline->timeline = $request->unithour[$index];
        $outline->course_id=$course->id;
        $outline->save();

        }
      }

          Session::flash('success', 'Successfully, Course Added !');
          return redirect()->back();

        } catch (\Exception $e) {

        }

          Session::flash('error', 'Something went wrong!');
          return redirect()->back();
        }


        public function settings()
          {
            $setting = Setting::first();
            return view('admin.system_settings',['setting'=>$setting]);
          }

          public function add_settings(Request $request)
            {
              $setting = Setting::first();
              $setting->student_time = $request->student;
              $setting->teacher_time = $request->teacher;
              $setting->save();

              return redirect()->back();

            }

            public function studentlogs(Request $request)
              {
                $students = Student::all();
                return view('admin.studentlogs',['students'=>$students]);
              }

              public function teacherlogs(Request $request)
                {
                  $teachers = Teacher::all();
                  return view('admin.teacherlogs',['teachers'=>$teachers]);
                }

}
