<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Grade;
use App\Modals\Course;
use App\Modals\Student;
use App\Modals\Registration;
use Session;
use Hash;
use Auth;

class StudentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function all_students()
    {
      $students = Registration::where('status' , 2)->get();
      $grades = Grade::all();
        return view('admin.all_students', ['students'=>$students,'grades'=>$grades]);
    }

    public function fee_students()
    {
        $students = Registration::where('status' , 1)->get();
        return view('admin.fee_students', ['students'=>$students]);
    }

    public function approved_students()
    {
        $students = Registration::where('status' , 2)->get();
        return view('admin.approved_students', ['students'=>$students]);
    }

    public function approvepayment(Request $request)
    {
       
      $students = Registration::where('id', $request->reg_id)->first();
      $students->status = 2;
      $students->save();
      Session::flash('success', 'Successfully, Approved !');
      return redirect()->back();
    }

}
