<?php

namespace App\Http\Controllers\Web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use App\Modals\Grade;
use App\Modals\Course;
use App\Modals\Student;
use App\Modals\Registration;
use App\Modals\Parenting;
use App\Modals\Contact;
use Session;
use Hash;
use Auth;
use Crypt;

class WebController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('web.index');
    }
    public function about()
    {
        return view('web.about');
    }
    public function franchise()
    {
        return view('web.franchise');
    }
    public function fastTrackCredit()
    {
        return view('web.fastTrackCredit');
    }
    public function summerSchool()
    {
        return view('web.summerSchool');
    }
    public function tution()
    {
        return view('web.tution');
    }
    public function howToApply()
    {
        return view('web.howToApply');
    }
    public function internationalStudent()
    {
        return view('web.internationalStudent');
    }
    public function contact()
    {
        return view('web.contact');
    }
    public function faq()
    {
        return view('web.faq');
    }
    public function registration($id)
    {
      $id = Crypt::decrypt($id);
      $course = Course::where('id', $id)->first();

      if($course)
      {
        return view('web.registration',['course'=>$course]);
      }
      else{
        return redirect()->back();
      }

    }

    public function grade_detail($id)
    {
      $id = Crypt::decrypt($id);
      $grade = Grade::where('id', $id)->first();

      if($grade)
      {
        return view('web.grade',['grade'=>$grade]);
      }
      else{
        return redirect()->back();
      }

    }

    public function course_detail($id)
    {
      $id = Crypt::decrypt($id);
      $course = Course::where('id', $id)->first();

      if($course)
      {
        return view('web.course_detail',['course'=>$course]);
      }
      else{
        return redirect()->back();
      }

    }

    public function submit_contactus(Request $request)
    {
      $contact = new Contact();
      $contact->name = $request->name;
      $contact->email = $request->email;
      $contact->phone = $request->phone;
      $contact->subject = $request->subject;
      $contact->message = $request->message;
      $contact->save();

      Session::flash('success', 'Submitted Successfully!');
        return redirect()->back();


    }

    public function registerStudent(Request $request)
    {
      $validatedData = $request->validate([
        'availablity' => 'required',
        'duration' => 'required',
        'family_name' => 'required',
        'given_name' => 'required',
        'oen' => 'required',
        'medical' => 'required',
        'gender' => 'required',
        'dob' => 'required',
        'residency' => 'required',
        'status_canada' => 'required',
        'email' => 'required',
        'password' => 'required',
        'street' => 'required',
        'apart' => 'required',
        'postal' => 'required',
        'city' => 'required',
        'province' => 'required',
        'home_phone' => 'required',
        'cell_no' => 'required',
        'last_school' => 'required',
        'last_grade' => 'required',
        'school_address' => 'required',
        'school_phone' => 'required',
        'last_year' => 'required',
        'relationship' => 'required',
        'parent_name' => 'required',
        'parent_phone' => 'required',
        'document' => 'required',
        'refrence' => 'required',
        'payment_type' => 'required',
        'signature_name' => 'required',
        'name_signature' => 'required',
        'notes' => 'required',
      ]);


      if(User::where('email' , $request->email)->count() > 0)
      {
        Session::flash('error', 'Email Already exsist!');
        return redirect()->back()->withInput();
      }


      $student = new Student();
      $student->family_name = $request->family_name;
      $student->given_name = $request->given_name;
      $student->oen = $request->oen;
      $student->medical = $request->medical;
      $student->gender = $request->gender;
      $student->dob = $request->dob;
      $student->residency_proof = $request->residency;
      $student->status_canada = $request->status_canada;
      $student->street = $request->street;
      $student->apart = $request->apart;
      $student->postal = $request->postal;
      $student->city = $request->city;
      $student->province = $request->province;
      $student->cell_no = $request->cell_no;
      $student->home_no = $request->home_phone;
      $student->name_school = $request->last_school;
      $student->last_grade = $request->last_grade;
      $student->school_address = $request->school_address;
      $student->school_phone = $request->school_phone;
      $student->last_year = $request->last_year;
      $student->save();


      $user = new User();
      $user->name = $request->given_name;
      $user->email = $request->email;
      $user->password = Hash::make($request->password);
      $user->student_id = $student->id;
      $user->save();
      $user->assignRole('Student');
      // Auth::login($user);

      $coursesss = Course::where('id', $request->course_id)->first();

      $registration = new Registration();
      $registration->grade_id = $request->grade_id;
      $registration->course_id = $request->course_id;
      $registration->availability = $request->availablity;
      $registration->duration = $request->duration;
      $registration->user_id = $user->id;
      $registration->student_id = $student->id;
      $registration->status = 0;
      $registration->total_amount = $coursesss->price;
      $registration->total_paid = 0;
      $registration->payment_type = $request->payment_type;
      $registration->notes = $request->notes;
      $registration->guardian_name = $request->name_signature;
      $registration->application = $request->signature_name;
      $registration->refrence = $request->refrence;
      $registration->document = $request->document;
      $registration->save();


      $parent = new Parenting();
      $parent->student_id = $student->id;
      $parent->relationship = $request->relationship;
      $parent->name = $request->parent_name;
      $parent->phone = $request->parent_phone;
      $parent->save();

      // $document = new Document();
      // $document->student_id = $student->id;
      //
      // $document->identification = $request->document;
      // $document->report_card = $request->document;
      // $document->credit_summary = $request->document;
      // $document->other = $request->document;
      // $document->save();
      //
      // $refrence = new Refrence();
      // $refrence->student_id = $student->id;
      // $refrence->user_id = $user->id;
      //
      // $refrence->google = $request->refrence;
      // $refrence->flyer = $request->refrence;
      // $refrence->referral = $request->refrence;
      // $refrence->signboard = $request->refrence;
      // $refrence->others = $request->refrence;
      // $refrence->save();


      Session::flash('success', 'Registration done!');
      return redirect()->back()->with(['status'=>1]);


    }
}
