<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('price')->nullable();
            $table->string('prerequisite')->nullable();
            $table->string('department')->nullable();
            $table->string('course_developer')->nullable();
            $table->string('development_date')->nullable();
            $table->string('revision_date')->nullable();
            $table->string('course_reviser')->nullable();
            $table->string('course_type')->nullable();
            $table->string('ministry_course_code')->nullable();
            $table->string('credit_value')->nullable();
            $table->string('satrategy')->nullable();
            $table->string('evaluation')->nullable();
            $table->string('ministry_curriculum_policy_doc')->nullable();
            $table->integer('grade_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('courses');
    }
}
