<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegistrationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('grade_id')->nullable();
            $table->string('course_id')->nullable();
            $table->string('availability')->nullable();
            $table->string('duration')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('student_id')->nullable();
            $table->string('status')->nullable();  // 0 -> reg , 1 -> paid , 2 - > approved
            $table->string('total_amount')->nullable();
            $table->string('total_paid')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('notes')->nullable();
            $table->string('application')->nullable();
            $table->string('guardian_name')->nullable();
            $table->string('refrence')->nullable();
            $table->string('document')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registrations');
    }
}
