/*
 Template Name: Foxia - Responsive Bootstrap 4 Admin Dashboard
 Author: Themesbrand
 File: Dashboard js
 */

!function ($) {
    "use strict";

    var Dashboard = function () {
    };

        //creates Stacked chart
        Dashboard.prototype.createStackedChart  = function(element, data, xkey, ykeys, labels, lineColors) {
            Morris.Bar({
                element: element,
                data: data,
                xkey: xkey,
                ykeys: ykeys,
                stacked: true,
                labels: labels,
                hideHover: 'auto',
                resize: true, //defaulted to true
                gridLineColor: '#eeeeee',
                barColors: lineColors
            });
        },

        //creates Donut chart
        Dashboard.prototype.createDonutChart = function (element, data, colors) {
            Morris.Donut({
                element: element,
                data: data,
                resize: true,
                colors: colors,
            });
        },

        // pie
        $('.peity-pie').each(function () {
            $(this).peity("pie", $(this).data());
        });

        //donut
        $('.peity-donut').each(function () {
            $(this).peity("donut", $(this).data());
        });

        // line
        $('.peity-line').each(function () {
            $(this).peity("line", $(this).data());
        });


        Dashboard.prototype.init = function () {

            //creating Stacked chart
            var $stckedData  = [
                { y: 'week1', a: 245 },
                { y: 'week2', a: 175 },
                { y: 'week3', a: 160},
                { y: 'week4', a: 175 }

            ];
            this.createStackedChart('morris-bar-stacked', $stckedData, 'y', ['a'], ['Registered Students'], ['#655be6']);



            //creating donut chart
            var $donutData = [
                {label: "grade 9", value: 12},
                {label: "Grade 10", value: 42},
                {label: "Grade 11", value: 20},
                {label: "Grade 12", value: 18}
            ];
            this.createDonutChart('morris-donut-example', $donutData, ['#46cd93', '#655be6', '#1699dd', '#fdba45']);


        },
        //init
        $.Dashboard = new Dashboard, $.Dashboard.Constructor = Dashboard
}(window.jQuery),

//initializing
    function ($) {
        "use strict";
        $.Dashboard.init();
    }(window.jQuery);
