@extends('layouts.student')

@section('styles')
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container-fluid">
          <div class="row">
              <div class="col-sm-12">
                  <div class="page-title-box">
                      <div class="row align-items-center">
                          <div class="col-md-8">
                              <h4 class="page-title mb-0">Student</h4>
                              <ol class="breadcrumb m-0">
                                  <li class="breadcrumb-item"><a href="#">Registration</a></li>
                                  <li class="breadcrumb-item active" aria-current="page">Pending Payment</li>
                              </ol>
                          </div>

                      </div>

                  </div>
              </div>
          </div>
          <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title">Registration</h4>
                            <div class="table-responsive mt-4">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Grade</th>
                                            <th scope="col">Course</th>
                                            <th scope="col">Status</th>
                                            <th scope="col" colspan="2">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($registration as $reg)
                                        <tr>
                                            <th scope="row">{{$loop->iteration}}</th>
                                            <td>{{$reg->student->given_name}}</td>
                                            <td>{{Auth::User()->email}}</td>
                                            <td>{{$reg->grade->name}}</td>
                                            <td>{{$reg->course->name}}</td>
                                            <td>@if($reg->status == 0)
                                              <span class="label label-danger">Payment Pending</span>
                                              @else
                                              {{$reg->status}}
                                              @endif
                                            </td>
                                            <td>
                                                <div>
                                                  @if($reg->status == 0)
                                                  <a data-toggle="modal" data-target="#addpayment" class="btn btn-warning btn-sm">Pay</a>
                                                  @endif
                                                  <a data-toggle="modal" data-target="#addpayment" class="btn btn-success btn-sm" >Details</a>
                                                </div>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div> <!-- container-fluid -->

    </div> <!-- content -->

    <footer class="footer">
        © 2020 - 2021  The Educators Academy
    </footer>
</div>


<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->
<!-- sample modal content -->
<div id="addpayment" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Submit Payment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="{{ route('student.submitPayment')}}" method="post">
                <div class="row">
                  <div class="col-md-12">
                    <label>Total Amount</label>
                    <input class="form-control" readonly name="name" value="{{$registration[0]->total_amount}}" placeholder="Enter name here ..."/>
                  </div>

                  <div class="col-md-12">
                    <label>Paid Amount</label>
                    <input class="form-control" required name="paid"  placeholder="Enter paid amount ..."/>
                  </div>

                </div>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Submit Payment</button>
            </div>
            {{ csrf_field()}}
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


@endsection

@section('scripts')

@endsection
