<?php

namespace App\Http\Controllers\Student;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Grade;
use App\Modals\Course;
use App\Modals\Student;
use App\Modals\Registration;
use Session;
use Hash;
use Auth;

class StudentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('studentuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {
        return view('student.dashboard');
    }
    public function pendingpayment()
    {
      $registration = Registration::where('student_id', Auth::user()->student_id)->get();

      return view('student.pendingpayment', ['registration'=>$registration]);
    }

    public function submitPayment(Request $request)
    {

      $registration = Registration::where('student_id', Auth::user()->student_id)->first();
      $registration->total_paid = $request->paid;
      $registration->status = 1;
      $registration->save();

      Session::flash('success', 'Successfully, Payment Paid, Please wait for Approval !');
      return redirect()->route('student.pendingpayment');
    }
}
