@extends('layouts.admin')



@section('styles')

@endsection



@section('content')

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->

<div class="content-page">

    <!-- Start content -->

    <div class="content">

        <div class="container-fluid">

          <div class="row">

              <div class="col-sm-12">

                  <div class="page-title-box">

                      <div class="row align-items-center">

                          <div class="col-md-8">

                              <h4 class="page-title mb-0">Courses</h4>

                              <ol class="breadcrumb m-0">

                                  <li class="breadcrumb-item"><a href="#">Dashboard</a></li>

                                  <li class="breadcrumb-item active" aria-current="page">Courses</li>

                              </ol>

                          </div>

                          <div class="col-md-4">

                              <div class="float-right d-none d-md-block">

                                  <div class="dropdown">

                                      <a class="btn btn-success btn-rounded" type="button"  href="{{ route('admin.newCourse')}}">

                                          <i class="fa fa-plus"></i> Add New Course

                                      </a>



                                  </div>

                              </div>

                          </div>

                      </div>



                  </div>

              </div>

          </div>

          <!-- end row -->

            <div class="row">

                <div class="col-lg-12">

                    <div class="card">

                        <div class="card-body">

                            <h4 class="mt-0 header-title">Courses List</h4>

                            <div class="table-responsive mt-4">

                                <table class="table  table-striped table-hover mb-0">

                                    <thead>

                                        <tr>

                                            <th scope="col">(#)</th>

                                            <th scope="col">Course Title</th>



                                            <th scope="col">Grade</th>
											  <th scope="col">Price</th>


                                            <th scope="col" colspan="2">Actions</th>

                                        </tr>

                                    </thead>

                                    <tbody>
                                      @foreach($courses as $c)
										<tr>
										<td>1</td>
											<td>{{$c->name}}</td>
											<td>{{$c->grade->name}}</td>
											<td> ${{$c->price}}</td>

											<td>   <a  class="btn btn-success btn-sm"><i class="ion-search text-white"></i></a>

                                                    <a href="{{ route('admin.editviewCourse' , $c->id)}}"  class="btn btn-warning btn-sm" ><i class="fa fa-pencil text-white"></i></a>
</td>


										</tr>
                    @endforeach







                                    </tbody>

                                </table>



                            </div>


                        </div>

                    </div>

                </div>

            </div>

            <!-- end row -->


        </div> <!-- container-fluid -->



    </div> <!-- content -->



    <footer class="footer">

        © 2020 - 2021  The Educators Academy

    </footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->

<!-- sample modal content -->




<div id="deleteCourseModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title mt-0" id="myModalLabel">Delete Course</h5>

                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>

            </div>

            <div class="modal-body">

              <form action="{{ route('admin.deleteCourse')}}" method="post">

                <div class="row">



<h4>Are you sure you want to delete this course ?</h4>

<input type="hidden" name="course_id" required id="course_id"/>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>

                <button type="submit" class="btn btn-primary waves-effect waves-light" >Delete Course</button>

            </div>

            {{ csrf_field()}}

            </form>

        </div><!-- /.modal-content -->

    </div><!-- /.modal-dialog -->

</div>

<!-- /.modal -->

@endsection



@section('scripts')
<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css"> -->
    <link rel="stylesheet" href="{{asset('assets/site.css')}}">
    <link rel="stylesheet" href="{{asset('assets/richtext.min.css')}}">
    <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script> -->
    <script src="{{asset('assets/jquery.richtext.js')}}"></script>
    <!-- <script>
        $(document).ready(function() {
            $('.content').richText();
            $('.content2').richText();
        });
    </script> -->
<script>

function setcourseid(id)

{

  $("#course_id").val(id);

}

</script>
	<script>

	var max_fields      = 20;
var wrapper         = $(".input_fields_wrap");
var add_button      = $(".add_field_button");
var remove_button   = $(".remove_field_button");

$(add_button).click(function(e){
	e.preventDefault();
	var total_fields = wrapper[0].childNodes.length;
	if(total_fields < max_fields){
		$(wrapper).append('<div class="form-group row"><label for="example-text-input" class="col-sm-2 col-form-label">Title</label><div class="col-sm-8"><input class="form-control" type="text" name="overall[]" ></div></div>', '<div class="form-group row"><label for="example-text-input" class="col-sm-2 col-form-label">Detail</label><div class="col-sm-8"><textarea required="" class="form-control" rows="5" name="overdetail[]"></textarea></div></div>');
	}
});
$(remove_button).click(function(e){
	e.preventDefault();
	var total_fields = wrapper[0].childNodes.length;
	if(total_fields>2){
		wrapper[0].childNodes[total_fields-2].remove();
	}
});
	</script>

  <script>

  var max_fields1      = 20;
var wrapper1         = $(".input_fields_wrap1");
var add_button1      = $(".add_field_button1");
var remove_button1   = $(".remove_field_button1");

$(add_button1).click(function(e){
  e.preventDefault();
  var total_fieldsa = wrapper1[0].childNodes.length;
  if(total_fieldsa < max_fields1){
    $(wrapper1).append('<div class="form-group row"><label for="example-text-input" class="col-sm-2 col-form-label">Title</label><div class="col-sm-8"><input class="form-control" type="text" name="contitle[]" ></div></div>', '<div class="form-group row"><label for="example-text-input" class="col-sm-2 col-form-label">Detail</label><div class="col-sm-8"><textarea required="" class="form-control" rows="5" name="condetail[]"></textarea></div></div>');
  }
});
$(remove_button1).click(function(e){
  e.preventDefault();
  var total_fieldsa = wrapper1[0].childNodes.length;
  if(total_fieldsa>2){
    wrapper1[0].childNodes[total_fieldsa-2].remove();
  }
});
  </script>


@endsection
