<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container-fluid">
          <div class="row">
              <div class="col-sm-12">
                  <div class="page-title-box">
                      <div class="row align-items-center">
                          <div class="col-md-8">
                              <h4 class="page-title mb-0">Courses</h4>
                              <ol class="breadcrumb m-0">
                                  <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                                  <li class="breadcrumb-item active" aria-current="page">Courses</li>
                              </ol>
                          </div>
                          <div class="col-md-4">
                              <div class="float-right d-none d-md-block">
                                  <div class="dropdown">
                                      <button class="btn btn-success btn-rounded" type="button"  data-toggle="modal" data-target="#addCourseModal">
                                          <i class="fa fa-plus"></i> Add New Course
                                      </button>

                                  </div>
                              </div>
                          </div>
                      </div>

                  </div>
              </div>
          </div>
          <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title">Courses List</h4>
                            <div class="table-responsive mt-4">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Description</th>
                                            <th scope="col">Grade</th>
                                            <th scope="col" colspan="2">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                                            <td><?php echo e($course->name); ?></td>
                                            <td><?php echo e($course->description); ?></td>
                                            <td><?php echo e($course->grade->name); ?></td>
                                            <td>
                                                <div>
                                                    <a data-toggle="modal" data-target="#editCourseModal" class="btn btn-warning btn-sm">Edit</a>
                                                    <a data-toggle="modal" data-target="#deleteCourseModal" class="btn btn-danger btn-sm" onclick="setcourseid(<?php echo e($course->id); ?>)">Delete</a>
                                                </div>
                                            </td>
                                        </tr>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div> <!-- container-fluid -->

    </div> <!-- content -->

    <footer class="footer">
        © 2020 - 2021  The Educators Academy
    </footer>
</div>


<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->
<!-- sample modal content -->
<div id="addCourseModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Add New Course</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="<?php echo e(route('admin.addCourse')); ?>" method="post">
                <div class="row">
                  <div class="col-md-12">
                    <label>Course Name</label>
                    <input class="form-control" required name="name" placeholder="Enter name here ..."/>
                  </div>

                  <div class="col-md-12">
                    <label>Description</label>
                    <textarea class="form-control"  name="description" placeholder="Enter description here ..."></textarea>
                  </div>

                  <div class="col-md-12">
                    <label>Grade</label>
                   <select required name="grade" class="form-control">
                     <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <option value="<?php echo e($grade->id); ?>"><?php echo e($grade->name); ?></option>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </select>
                  </div>
                </div>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Add Grade</button>
            </div>
            <?php echo e(csrf_field()); ?>

            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


<div id="deleteCourseModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Delete Course</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="<?php echo e(route('admin.deleteCourse')); ?>" method="post">
                <div class="row">

<h4>Are you sure you want to delete this course ?</h4>
<input type="hidden" name="course_id" required id="course_id"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Delete Course</button>
            </div>
            <?php echo e(csrf_field()); ?>

            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function setcourseid(id)
{
  $("#course_id").val(id);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\freelance\school\resources\views/admin/courses.blade.php ENDPATH**/ ?>