@extends('layouts.admin')

@section('styles')
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container-fluid">
          <div class="row">
              <div class="col-sm-12">
                  <div class="page-title-box">
                      <div class="row align-items-center">
                          <div class="col-md-8">
                              <h4 class="page-title mb-0">Options</h4>
                              <ol class="breadcrumb m-0">
                                  <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                                  <li class="breadcrumb-item active" aria-current="page">Options</li>
                              </ol>
                          </div>
                          <div class="col-md-4">
                              <div class="float-right d-none d-md-block">
                                  <div class="dropdown">
                                      <button class="btn btn-success btn-rounded" type="button"  data-toggle="modal" data-target="#addGradeModal">
                                          <i class="fa fa-plus"></i> Add New Options
                                      </button>

                                  </div>
                              </div>
                          </div>
                      </div>

                  </div>
              </div>
          </div>
          <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title">Options List</h4>
                            <div class="table-responsive mt-4">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col" colspan="2">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($menus as $menu)
                                        <tr>
                                            <th scope="row">{{$loop->iteration}}</th>
                                            <td>{{$menu->name}}</td>
                                            <td>
                                                <div>
                                                    <a data-toggle="modal" data-target="#addGradeModal" class="btn btn-warning btn-sm">Edit</a>
                                                    <a data-toggle="modal" data-target="#deleteGradeModal" class="btn btn-danger btn-sm" onclick="setgradeid({{$grade->id}})">Delete</a>
                                                </div>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div> <!-- container-fluid -->

    </div> <!-- content -->

    <footer class="footer">
        © 2020 - 2021
    </footer>
</div>


<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->
<!-- sample modal content -->
<div id="addGradeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Add New Option/Menu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="{{ route('admin.addGrade')}}" method="post">
                <div class="row">
                  <div class="col-md-12">
                    <label>Menu Name</label>
                    <input class="form-control" required name="name" placeholder="Enter name here ..."/>
                  </div>

                </div>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Add Menu</button>
            </div>
            {{ csrf_field()}}
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


<div id="deleteGradeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Delete Menu</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="{{ route('admin.deleteGrade')}}" method="post">
                <div class="row">

<h4>Are you sure you want to delete this menu ?</h4>
<input type="hidden" name="grade_id" required id="grade_id"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Delete Menu</button>
            </div>
            {{ csrf_field()}}
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- /.modal -->
@endsection

@section('scripts')
<script>
function setgradeid(id)
{
  $("#grade_id").val(id);
}
</script>
@endsection
